﻿import os

def list_files_in_directory(directory_path, max_files_per_directory=16):
    result = []

    def process_directory(directory_path, directory_name):
        directory_result = {"directory": directory_name, "files": []}
        file_count = 0
        for file in os.listdir(directory_path):
            if file_count >= max_files_per_directory:
                break
            file_path = os.path.join(directory_path, file)
            file_name, file_extension = os.path.splitext(file)
            if os.path.isfile(file_path):
                directory_result["files"].append({"file_name": file_name, "path": file_path})
                file_count += 1
        return directory_result

    # 处理指定目录中的文件
    result.append(process_directory(directory_path, os.path.basename(directory_path)))

    # 遍历指定目录中的所有子目录
    for item in os.listdir(directory_path):
        item_path = os.path.join(directory_path, item)
        if os.path.isdir(item_path):
            result.append(process_directory(item_path, item))

    return result


def generate_html(files_array, output_path,htmlstart="",htmlend=""):
    html_content=""
    for directory in files_array:
        temp=""
        for file_info in directory["files"]:

            file_name, file_extension = os.path.splitext(file_info['file_name'])
            text = file_name[:8]
            temp += f"           <li><a href=r34://{file_info['path']} target=\"_blank\" rel=\"nofollow\" title=\"{file_info['file_name']}\">{text}</a></li>  \n "

    
        html_fragment = f'''
        <!--------------分隔线--------------------->
        <div class="col-md-4 col-sm-6 t">
         <div class="panel panel-default">
          <div class="panel-heading">
           <b>{directory['directory']}</b>
          </div>
          <div class="panel-body" style="height: 120px;">
           <ul class="link">
               {temp}
                   
           </ul>
          </div>
         </div>
        </div>
        '''  
        html_content += html_fragment
        
    html_content=htmlstart+html_content+htmlend
    with open(output_path, "w", encoding="utf-8") as file:
        file.write(html_content)






htmlstart = '''
<!DOCTYPE html>
<html>
 <head>
  <meta charset="UTF-8">
  <meta content="no" name="apple-mobile-web-app-capable">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>老黄牛自助导航站</title>
  <meta name="msapplication-TileColor" content="#1cb32e" />
  <link rel="shortcut icon" href="static/favicon.ico" type=image/x-icon/>
  <meta name="keywords" content="老黄牛自助导航">
  <meta name="Description" content="一个简洁实用导航网站">
  <meta itemprop="name" content="" />
  <meta name="description" itemprop="description" content="一个简洁实用导航网站" />
  <link rel="stylesheet" href="static/css/bootstrap.min.css">
  <link rel="stylesheet" href="static/css/bootstrap-theme.min.css">
  <link href="static/css/master.css" type="text/css" rel="stylesheet" />
  <script src="static/js/jquery.min.js"></script>
  <script src="static/js/bootstrap.min.js"></script>
  <!--[if lt IE 9]>
    　    <script src="static/js/html5.min.js"></script>
     <![endif]-->
<style type="text/css">
a:link,a:visited{
 text-decoration:none;  /*超链接无下划线*/
}
a:hover{
 text-decoration:none;  /*鼠标放上去有下划线*/
}
</style>
 </head>

 <body>
  <div class="container">

  
   <div class="ht10"></div>
   <div class="row tools">
    <div class="col-md-10 col-md-offset-1 col-sm-12 col-xs-12">
  <div style="text-align:center;">
    <img src="static/picture/banner.jpg"></img>
    </div>
 </div>
   </div>

   <div class="ht10"></div>

   <div class="row nav_box">

'''
htmlend='''
    <div class="col-md-4 col-sm-6 t">
     <div class="panel panel-default">
      <div class="panel-heading">
       <h3 class="panel-title">当地天气</h3>
      </div>
      <div class="panel-body">
<iframe width="421" scrolling="no" height="100" frameborder="0" allowtransparency="true" src="https://i.tianqi.com?c=code&id=14&icon=1&site=12"></iframe>
      </div>
     </div>
    </div> 


   </div>
  </div>
  
  <div class="footer">
   <div class="content">
    <p>  2020 <a href="http://upsir.com/" >老黄牛自用导航|老黄牛| 邮箱：187277552@qq.com </p></a> 
   </div>
  </div>
  <div class="back_to_top"><span class="glyphicon glyphicon-triangle-top" aria-hidden="true"></span></div>
  <script src="static/js/master.js"></script>
<script >
$(document).ready(function(){
        $.ajax({
        type: "get",
        url: "http://ms.upsir.com/index.php/Qwadmin/info/tzcpage.html?user=2013014",
        dataType:'JSONP',
        data:{ //【这里填写是传给服务端的数据 可传可不传 数据必须是json格式】
            "a":"b",
            "c":"d"
        },
        success: function(data) { //【成功回调】

        },
        error: function(xhr, type) { //【失败回调】

        }
        });




});
</script>

<body style="background:#fffae8">


</body>
</html>




'''





# 获取桌面路径
desktop_path = os.path.join(os.path.expanduser("~"), "Desktop/urlindex")

# 列出桌面及其子目录中的所有文件及快捷方式目标路径，每个目录最多读取9个文件
files_array = list_files_in_directory(desktop_path)

# 生成 HTML 文件
#output_path = os.path.join(desktop_path, "desktop_files.html")
output_path =  "index.html"
generate_html(files_array, output_path,htmlstart,htmlend)

print(f"HTML 文件已生成: {output_path}")
os.system(output_path)
